#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>

using namespace std;

struct Runner {
    long long position, speed;

    bool operator<(const Runner& other) const {
        return position + speed > other.position + other.speed;
    }
};

int main() {
    int N;
    long long K;
    cin >> N >> K;

    vector<Runner> runners(N);

    for (int i = 0; i < N; ++i) {
        cin >> runners[i].position >> runners[i].speed;
    }


    priority_queue<Runner> pq(runners.begin(), runners.end());

    while (true) {

        Runner fastest = pq.top();
        pq.pop();

        long long overtaking_time = fastest.position / fastest.speed;


        if (overtaking_time < K) {
            cout.precision(15);
            cout << fixed << static_cast<double>(overtaking_time) << endl;
            return 0;
        }


        fastest.position += fastest.speed * K;

        pq.push(fastest);
    }

    return 0;
}